unit fEntity;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, DXFConv, sgConsts, Spin;

type
  TfmCreateEntity = class(TForm)
    pnlMain: TPanel;
    Label1: TLabel;
    cbEntity: TComboBox;
    lblColor: TLabel;
    mmCoordinates: TMemo;
    btnOK: TButton;
    btnCancel: TButton;
    pnlColor: TPanel;
    bntColor: TButton;
    ColorDialog1: TColorDialog;
    lblWidth: TLabel;
    seWeight: TSpinEdit;
    procedure FormCreate(Sender: TObject);
    procedure cbEntityChange(Sender: TObject);
    procedure bntColorClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

function GetEntity: TsgDXFEntity;

implementation

{$R *.DFM}


function GetEntity: TsgDXFEntity;
var
  fmCreateEntity: TfmCreateEntity;
  Dc: Char;
  St: TStrings;
  I: Integer;
  S: string;
  Vertex: TsgDXFVertex;
  v2DPolyline: Tsg2DPolyline;
  v2DArc: Tsg2DArc;
  v2DBList: Tsg2DBoundaryList;
  v2DEllipse: Tsg2DEllipse;
  vPoint2D: TF2DPoint;
  vHPData: PsgHatchPatternData;
begin
  Result := nil;
  fmCreateEntity := TfmCreateEntity.Create(Application);
  Dc := DecimalSeparator;
  try
    DecimalSeparator := '.';
    fmCreateEntity.ShowModal;
    if fmCreateEntity.ModalResult = mrOK then
    begin
      St := fmCreateEntity.mmCoordinates.Lines;
      case fmCreateEntity.cbEntity.ItemIndex of
        0:
          begin
            Result := TsgDXFLine.Create;
            TsgDXFLine(Result).Point := MakeFPoint(ConvToFloatDef(St.Values['X1'],
              0.0), ConvToFloatDef(St.Values['Y1'], 0.0),
              ConvToFloatDef(St.Values['Z1'], 0.0));
            TsgDXFLine(Result).Point1 := MakeFPoint(ConvToFloatDef(St.Values['X2'],
              0.0), ConvToFloatDef(St.Values['Y2'], 0.0),
              ConvToFloatDef(St.Values['Z2'], 0.0));
          end;
        1:
          begin
            I := 1;
            S := St.Values['X' + IntToStr(I)];
            Result := TsgDXFPolyline.Create;
            repeat
              Vertex := TsgDXFVertex.Create;
              Vertex.Point := MakeFPoint(ConvToFloatDef(St.Values['X' + IntToStr(I)],
              0.0), ConvToFloatDef(St.Values['Y' + IntToStr(I)], 0.0),
              ConvToFloatDef(St.Values['Z' + IntToStr(I)], 0.0));
              Inc(I);
              S := St.Values['X' + IntToStr(I)];
              Result.AddEntity(Vertex);
            until S = '';
          end;
        2:
          begin
            Result := TsgDXFCircle.Create;
            TsgDXFCircle(Result).Radius := ConvToFloatDef(St.Values['Radius'],
              100.0);
            TsgDXFCircle(Result).Point := MakeFPoint(ConvToFloatDef(St.Values['X'],
              0.0), ConvToFloatDef(St.Values['Y'], 0.0),
              ConvToFloatDef(St.Values['Z'], 0.0));
          end;
        3:
          begin
            Result := TsgCADHatch.Create;
            v2DBList := Tsg2DBoundaryList.Create;
            TsgCADHatch(Result).BoundaryData.Add(v2DBList);
            v2DPolyline := Tsg2DPolyline.Create;
            v2DBList.Add(v2DPolyline);
            vPoint2D := MakeF2DPoint(ConvToFloatDef(St.Values['X1'],
              0.0), ConvToFloatDef(St.Values['Y1'], 0.0));
            v2DPolyline.AddVertex(vPoint2D);
            vPoint2D := MakeF2DPoint(ConvToFloatDef(St.Values['X2'],
              0.0), ConvToFloatDef(St.Values['Y2'], 0.0));
            v2DPolyline.AddVertex(vPoint2D);
            vPoint2D := MakeF2DPoint(ConvToFloatDef(St.Values['X3'],
              0.0), ConvToFloatDef(St.Values['Y3'], 0.0));
            v2DPolyline.AddVertex(vPoint2D);
            vPoint2D := MakeF2DPoint(ConvToFloatDef(St.Values['X4'],
              0.0), ConvToFloatDef(St.Values['Y4'], 0.0));
            v2DPolyline.AddVertex(vPoint2D);
            TsgCADHatch(Result).SetColor(clBlue);

            vHPData := new(PsgHatchPatternData);
            vHPData.BaseP := MakeFPoint(0, 0, 0);
            vHPData.Offset := MakeFPoint(2, 2, 0);
            vHPData.LineAngle := 40.0;
            vHPData.IsDash := False;
            vHPData.Lines := nil;
            vHPData.DashNum := 0;
            TsgCADHatch(Result).HatchPatternData.Add(vHPData);
          end;
        4:
          begin
            Result := TsgDXFText.Create;
            TsgDXFText(Result).Point := MakeFPoint(ConvToFloatDef(St.Values['Insert point'],
              0.0), ConvToFloatDef(St.Values['Y'], 0.0),
              ConvToFloatDef(St.Values['Z'], 0.0));
            TsgDXFText(Result).Height := ConvToFloatDef(St.Values['Height'], 0.0);
            TsgDXFText(Result).Text := St.Values['Text'];
          end;
        5, 6:
          begin
            Result := TsgCADCurvePolygon .Create;
            v2DBList := Tsg2DBoundaryList.Create;
            TsgCADHatch(Result).BoundaryData.Add(v2DBList);
            v2DArc := Tsg2DArc.Create;
            v2DBList.Add(v2DArc);
            v2DArc.CenterPoint := MakeF2DPoint(ConvToFloatDef(St.Values['X'],
              0.0), ConvToFloatDef(St.Values['Y'], 0.0));
            v2DArc.Radius := ConvToFloatDef(St.Values['Radius'], 0.0);
            v2DArc.CounterClockWise := LowerCase(St.Values['CounterClockWise']) = 'true';
            v2DArc.StartParam := ConvToFloatDef(St.Values['StartParam'], 0.0);
            v2DArc.EndParam := ConvToFloatDef(St.Values['EndParam'], 0.0);
          end;
        7:
          begin
            Result := TsgCADCurvePolygon .Create;
            v2DBList := Tsg2DBoundaryList.Create;
            TsgCADHatch(Result).BoundaryData.Add(v2DBList);
            v2DEllipse := Tsg2DEllipse.Create;
            v2DBList.Add(v2DEllipse);
            v2DEllipse.CenterPoint := MakeF2DPoint(ConvToFloatDef(St.Values['X'],
              0.0), ConvToFloatDef(St.Values['Y'], 0.0));
            v2DEllipse.Radius := ConvToFloatDef(St.Values['Radius'], 0.0);
            v2DEllipse.CounterClockWise := LowerCase(St.Values['CounterClockWise']) = 'true';
            v2DEllipse.StartParam := ConvToFloatDef(St.Values['StartParam'], 0.0);
            v2DEllipse.EndParam := ConvToFloatDef(St.Values['EndParam'], 0.0);
            v2DEllipse.MajorPoint := MakeF2DPoint(ConvToFloatDef(St.Values['MX'],
              0.0), ConvToFloatDef(St.Values['MY'], 0.0));
            v2DEllipse.IsAngleInParam := LowerCase(St.Values['IsAngleInParam']) = 'true';
          end;
      end;
      Result.SetColor(fmCreateEntity.pnlColor.Color);
      Result.SetLWeight(fmCreateEntity.seWeight.Value);
    end;
  finally
    DecimalSeparator := Dc;
    fmCreateEntity.Free;
  end;
end;


procedure TfmCreateEntity.FormCreate(Sender: TObject);
begin
  cbEntity.ItemIndex := 0;
end;

procedure TfmCreateEntity.cbEntityChange(Sender: TObject);
begin
  mmCoordinates.Clear;
  case cbEntity.ItemIndex of
    0:
      begin
        mmCoordinates.Lines.Add('First point');
        mmCoordinates.Lines.Add('X1=0.0');
        mmCoordinates.Lines.Add('Y1=0.0');
        mmCoordinates.Lines.Add('Z1=0.0');
        mmCoordinates.Lines.Add('Second point');
        mmCoordinates.Lines.Add('X2=1000.0');
        mmCoordinates.Lines.Add('Y2=1000.0');
        mmCoordinates.Lines.Add('Z2=0.0');
      end;
    1:
      begin
        mmCoordinates.Lines.Add('First point');
        mmCoordinates.Lines.Add('X1=0.0');
        mmCoordinates.Lines.Add('Y1=0.0');
        mmCoordinates.Lines.Add('Z1=0.0');
        mmCoordinates.Lines.Add('Second point');
        mmCoordinates.Lines.Add('X2=500.0');
        mmCoordinates.Lines.Add('Y2=400.0');
        mmCoordinates.Lines.Add('Z2=0.0');
        mmCoordinates.Lines.Add('Third point');
        mmCoordinates.Lines.Add('X3=800.0');
        mmCoordinates.Lines.Add('Y3=1000.0');
        mmCoordinates.Lines.Add('Z3=0.0');
        mmCoordinates.Lines.Add('Fourth point');
        mmCoordinates.Lines.Add('X4=1500.0');
        mmCoordinates.Lines.Add('Y4=3000.0');
        mmCoordinates.Lines.Add('Z4=0.0');
        mmCoordinates.Lines.Add('');
      end;
    2:
      begin
        mmCoordinates.Lines.Add('Radius=100.0');
        mmCoordinates.Lines.Add('Center');
        mmCoordinates.Lines.Add('X=300.0');
        mmCoordinates.Lines.Add('Y=300.0');
        mmCoordinates.Lines.Add('Z=0.0');
      end;
    3:
      begin
        mmCoordinates.Lines.Add('First boundary');
        mmCoordinates.Lines.Add('First point');
        mmCoordinates.Lines.Add('X1=75.0');
        mmCoordinates.Lines.Add('Y1=8.0');
        mmCoordinates.Lines.Add('Z1=0.0');
        mmCoordinates.Lines.Add('Second point');
        mmCoordinates.Lines.Add('X2=93.0');
        mmCoordinates.Lines.Add('Y2=29.0');
        mmCoordinates.Lines.Add('Z2=0.0');
        mmCoordinates.Lines.Add('Third point');
        mmCoordinates.Lines.Add('X3=109.0');
        mmCoordinates.Lines.Add('Y3=12.0');
        mmCoordinates.Lines.Add('Z3=0.0');
        mmCoordinates.Lines.Add('Fourth point');
        mmCoordinates.Lines.Add('X4=75.0');
        mmCoordinates.Lines.Add('Y4=8.0');
        mmCoordinates.Lines.Add('Z4=0.0');
      end;
    4:
      begin
        mmCoordinates.Lines.Add('Insert point');
        mmCoordinates.Lines.Add('X=100.0');
        mmCoordinates.Lines.Add('Y=80.0');
        mmCoordinates.Lines.Add('Z=0.0');
        mmCoordinates.Lines.Add('Height=100');
        mmCoordinates.Lines.Add('Text=Hello World!!!');
      end;
    5:
      begin
        mmCoordinates.Lines.Add('Center point');
        mmCoordinates.Lines.Add('X=300.0');
        mmCoordinates.Lines.Add('Y=300.0');
        mmCoordinates.Lines.Add('Radius');
        mmCoordinates.Lines.Add('Radius=100.0');
        mmCoordinates.Lines.Add('CounterClockWise');
        mmCoordinates.Lines.Add('CounterClockWise=False');
        mmCoordinates.Lines.Add('StartParam');
        mmCoordinates.Lines.Add('StartParam=45.0');
        mmCoordinates.Lines.Add('EndParam');
        mmCoordinates.Lines.Add('EndParam=315.0');
      end;
    6:
      begin
        mmCoordinates.Lines.Add('Center point');
        mmCoordinates.Lines.Add('X=300.0');
        mmCoordinates.Lines.Add('Y=300.0');
        mmCoordinates.Lines.Add('Radius');
        mmCoordinates.Lines.Add('Radius=100.0');
        mmCoordinates.Lines.Add('CounterClockWise');
        mmCoordinates.Lines.Add('CounterClockWise=False');
        mmCoordinates.Lines.Add('StartParam');
        mmCoordinates.Lines.Add('StartParam=0.0');
        mmCoordinates.Lines.Add('EndParam');
        mmCoordinates.Lines.Add('EndParam=0.0');
      end;
    7:
      begin
        mmCoordinates.Lines.Add('Center point');
        mmCoordinates.Lines.Add('X=300.0');
        mmCoordinates.Lines.Add('Y=300.0');
        mmCoordinates.Lines.Add('Radius');
        mmCoordinates.Lines.Add('Radius=5.0');
        mmCoordinates.Lines.Add('CounterClockWise');
        mmCoordinates.Lines.Add('CounterClockWise=False');
        mmCoordinates.Lines.Add('StartParam');
        mmCoordinates.Lines.Add('StartParam=0.0');
        mmCoordinates.Lines.Add('EndParam');
        mmCoordinates.Lines.Add('EndParam=360.0');
        mmCoordinates.Lines.Add('IsAngleInParam');
        mmCoordinates.Lines.Add('True');
        mmCoordinates.Lines.Add('MajorPoint');
        mmCoordinates.Lines.Add('MX=0');
        mmCoordinates.Lines.Add('MY=200');
      end;
  end;
end;


procedure TfmCreateEntity.bntColorClick(Sender: TObject);
begin
  if ColorDialog1.Execute then
    pnlColor.Color := ColorDialog1.Color;
end;

end.

